<?php
session_start();
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

echo "Testing Admin Login...\n";

try {
    // Test admin login
    $email = "admin@ensia.com";
    $password = "password";
    
    $query = "SELECT * FROM users WHERE (email = ? OR username = ?) AND role = 'admin'";
    $stmt = $db->prepare($query);
    $stmt->execute([$email, $email]);
    
    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (password_verify($password, $user['password'])) {
            echo "✓ Admin login successful!\n";
            echo "User ID: " . $user['id'] . "\n";
            echo "Name: " . $user['full_name'] . "\n";
            echo "Role: " . $user['role'] . "\n";
            
            // Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_role'] = $user['role'];
            $_SESSION['user_name'] = $user['full_name'];
            
            echo "✓ Session set successfully!\n";
            
            // Test admin_manage_technicians.php
            echo "\nTesting admin_manage_technicians.php...\n";
            
            // Simulate the page load
            ob_start();
            include 'admin_manage_technicians.php';
            $output = ob_get_clean();
            
            if (strpos($output, 'Kelola Teknisi') !== false) {
                echo "✓ admin_manage_technicians.php loaded successfully!\n";
            } else {
                echo "❌ admin_manage_technicians.php failed to load properly\n";
            }
            
        } else {
            echo "❌ Invalid password!\n";
        }
    } else {
        echo "❌ Admin user not found!\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
