<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

echo "Testing Assign Technician (Different Customer)...\n";

try {
    // Test data - different customer
    $customer_id = 2; // Siti Nurhaliza
    $teknisi_id = 4; // Teknisi 2
    
    // Check if customer already has installation
    $check_query = "SELECT id FROM installations WHERE customer_id = ?";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->execute([$customer_id]);
    
    if ($check_stmt->rowCount() > 0) {
        echo "❌ Pelanggan ini sudah memiliki instalasi!\n";
        
        // Show existing installation
        $existing_query = "SELECT i.*, u.full_name as teknisi_name FROM installations i 
                          JOIN users u ON i.teknisi_id = u.id 
                          WHERE i.customer_id = ?";
        $existing_stmt = $db->prepare($existing_query);
        $existing_stmt->execute([$customer_id]);
        $existing = $existing_stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "Existing installation:\n";
        echo "- ID: " . $existing['id'] . "\n";
        echo "- Teknisi: " . $existing['teknisi_name'] . "\n";
        echo "- Status: " . $existing['status'] . "\n";
    } else {
        // Create installation assignment
        $query = "INSERT INTO installations (customer_id, teknisi_id, kabel_meter, status) VALUES (?, ?, 0, 'assigned')";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$customer_id, $teknisi_id])) {
            echo "✓ Teknisi berhasil ditugaskan!\n";
            echo "Installation ID: " . $db->lastInsertId() . "\n";
            echo "Customer ID: $customer_id\n";
            echo "Teknisi ID: $teknisi_id\n";
            echo "Status: assigned\n";
        } else {
            echo "❌ Gagal menugaskan teknisi!\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>




