<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Tambah Data Pelanggan dengan Foto KTP - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .form-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .upload-area {
            border: 2px dashed #dee2e6;
            border-radius: 10px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .upload-area:hover {
            border-color: #667eea;
            background-color: #f8f9fa;
        }
        .upload-area.dragover {
            border-color: #667eea;
            background-color: #e3f2fd;
        }
        .preview-container {
            margin-top: 1rem;
        }
        .preview-img {
            max-width: 200px;
            max-height: 150px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>📝 Demo - Tambah Data Pelanggan dengan Foto KTP</h3>
            <p class="lead">Form lengkap dengan fitur upload foto KTP dan preview</p>
        </div>
        
        <!-- Features Info -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-camera me-2"></i>Upload Foto KTP</h6>
                    <p class="text-muted small mb-0">Upload foto KTP dengan format JPG/PNG maksimal 5MB</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-eye me-2"></i>Preview Foto</h6>
                    <p class="text-muted small mb-0">Preview foto sebelum upload dengan validasi real-time</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-shield-alt me-2"></i>Validasi File</h6>
                    <p class="text-muted small mb-0">Validasi format, ukuran, dan tipe file otomatis</p>
                </div>
            </div>
        </div>
        
        <!-- Form Demo -->
        <div class="form-container">
            <h4 class="mb-4">
                <i class="fas fa-user-plus me-2"></i>Form Tambah Data Pelanggan
            </h4>
            
            <form id="demoForm">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="nama_lengkap" class="form-label">
                            <i class="fas fa-user me-2"></i>Nama Lengkap *
                        </label>
                        <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" 
                               value="Ahmad Wijaya" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="pekerjaan" class="form-label">
                            <i class="fas fa-briefcase me-2"></i>Pekerjaan
                        </label>
                        <input type="text" class="form-control" id="pekerjaan" name="pekerjaan" 
                               value="Karyawan Swasta">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label for="alamat_lengkap" class="form-label">
                        <i class="fas fa-map-marker-alt me-2"></i>Alamat Lengkap *
                    </label>
                    <textarea class="form-control" id="alamat_lengkap" name="alamat_lengkap" rows="3" required>Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi</textarea>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="nomor_hp" class="form-label">
                            <i class="fas fa-phone me-2"></i>Nomor HP *
                        </label>
                        <input type="text" class="form-control" id="nomor_hp" name="nomor_hp" 
                               value="081234567890" maxlength="15" required>
                        <div class="form-text">Format: 08xxxxxxxxxx</div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">
                            <i class="fas fa-envelope me-2"></i>Email
                        </label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="ahmad.wijaya@email.com">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label for="nik_ktp" class="form-label">
                        <i class="fas fa-id-card me-2"></i>NIK KTP *
                    </label>
                    <input type="text" class="form-control" id="nik_ktp" name="nik_ktp" 
                           value="1234567890123456" maxlength="16" pattern="[0-9]{16}" required>
                    <div class="form-text">NIK KTP harus 16 digit angka</div>
                </div>
                
                <!-- Upload Foto KTP -->
                <div class="mb-4">
                    <label for="foto_ktp" class="form-label">
                        <i class="fas fa-camera me-2"></i>Foto KTP
                    </label>
                    <div class="upload-area" onclick="document.getElementById('foto_ktp').click()">
                        <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                        <h6>Klik untuk Upload Foto KTP</h6>
                        <p class="text-muted small mb-0">Drag & drop atau klik untuk memilih file</p>
                        <p class="text-muted small">Format: JPG/PNG, maksimal 5MB</p>
                    </div>
                    <input type="file" class="form-control d-none" id="foto_ktp" name="foto_ktp" 
                           accept="image/jpeg,image/jpg,image/png">
                    <div class="form-text">
                        <i class="fas fa-info-circle me-1"></i>
                        Format: JPG/PNG, maksimal 5MB. Foto akan otomatis diresize.
                    </div>
                    <div id="foto-preview" class="preview-container" style="display: none;">
                        <div class="d-flex align-items-center">
                            <img id="preview-img" src="" alt="Preview Foto KTP" class="preview-img">
                            <div class="ms-3">
                                <h6>Preview Foto KTP</h6>
                                <p class="text-muted small mb-2">File siap diupload</p>
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeFoto()">
                                    <i class="fas fa-times me-1"></i>Hapus
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between">
                    <button type="button" class="btn btn-secondary" onclick="resetForm()">
                        <i class="fas fa-undo me-2"></i>Reset Form
                    </button>
                    <button type="button" class="btn btn-primary" onclick="simulateSubmit()">
                        <i class="fas fa-save me-2"></i>Simpan Data
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Features Detail -->
        <div class="row">
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-check-circle me-2 text-success"></i>Validasi yang Tersedia</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Format file (JPG/PNG)</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Ukuran file (maksimal 5MB)</li>
                        <li><i class="fas fa-check me-2 text-success"></i>NIK KTP 16 digit angka</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Nomor HP format valid</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Email format valid</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-cogs me-2 text-info"></i>Fitur Upload</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Drag & drop upload</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Preview foto real-time</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Validasi client-side</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Hapus foto sebelum upload</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Nama file otomatis</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_installed_customers.php" class="btn btn-outline-light">
                <i class="fas fa-check-double me-2"></i>Lihat Pelanggan Selesai
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Validasi NIK KTP hanya angka
        document.getElementById('nik_ktp').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        
        // Validasi nomor HP hanya angka
        document.getElementById('nomor_hp').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        
        // Drag & drop upload
        const uploadArea = document.querySelector('.upload-area');
        const fileInput = document.getElementById('foto_ktp');
        
        uploadArea.addEventListener('dragover', function(e) {
            e.preventDefault();
            uploadArea.classList.add('dragover');
        });
        
        uploadArea.addEventListener('dragleave', function(e) {
            e.preventDefault();
            uploadArea.classList.remove('dragover');
        });
        
        uploadArea.addEventListener('drop', function(e) {
            e.preventDefault();
            uploadArea.classList.remove('dragover');
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                fileInput.files = files;
                handleFileSelect(files[0]);
            }
        });
        
        // Preview foto KTP
        fileInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                handleFileSelect(file);
            }
        });
        
        function handleFileSelect(file) {
            // Validasi ukuran file (5MB)
            if (file.size > 5 * 1024 * 1024) {
                alert('Ukuran file terlalu besar! Maksimal 5MB.');
                fileInput.value = '';
                return;
            }
            
            // Validasi tipe file
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
            if (!allowedTypes.includes(file.type)) {
                alert('Format file tidak valid! Gunakan JPG atau PNG.');
                fileInput.value = '';
                return;
            }
            
            // Tampilkan preview
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('preview-img').src = e.target.result;
                document.getElementById('foto-preview').style.display = 'block';
            };
            reader.readAsDataURL(file);
        }
        
        // Hapus foto
        function removeFoto() {
            fileInput.value = '';
            document.getElementById('foto-preview').style.display = 'none';
        }
        
        // Reset form
        function resetForm() {
            document.getElementById('demoForm').reset();
            document.getElementById('foto-preview').style.display = 'none';
        }
        
        // Simulate submit
        function simulateSubmit() {
            const form = document.getElementById('demoForm');
            const formData = new FormData(form);
            
            // Validasi form
            if (!form.checkValidity()) {
                alert('Mohon lengkapi semua field yang wajib diisi!');
                return;
            }
            
            // Validasi foto jika ada
            if (fileInput.files.length > 0) {
                const file = fileInput.files[0];
                if (file.size > 5 * 1024 * 1024) {
                    alert('Ukuran file foto KTP terlalu besar! Maksimal 5MB.');
                    return;
                }
                if (!['image/jpeg', 'image/jpg', 'image/png'].includes(file.type)) {
                    alert('Format file foto KTP tidak valid! Gunakan JPG atau PNG.');
                    return;
                }
            }
            
            // Simulate success
            alert('Data pelanggan berhasil disimpan!\n\nFitur ini akan menyimpan foto KTP ke folder uploads/ktp/ dengan nama file yang unik.');
        }
    </script>
</body>
</html>
