# 🎉 ENSIA - Aplikasi Berhasil Dijalankan!

## Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

### ✅ **Status: RUNNING & DATABASE CONNECTED**

Aplikasi ENSIA telah berhasil dijalankan dengan PHP Development Server dan database MySQL terhubung dengan baik.

---

## 🌐 **Akses Aplikasi**

### **URL Utama:**
- ** Main Application**: `http://localhost:8080`
- **📊 Status App**: `http://localhost:8080/status.php`
- ** Test Database**: `http://localhost:8080/test_db.php`
- **ℹ️ Info Login**: `http://localhost:8080/login_info.html`

---

## ✅ **Database Status: CONNECTED**

### **Konfigurasi Database:**
- **Host**: localhost
- **Database**: ensia_db
- **Username**: ensia_user
- **Password**: ensia_password
- **Status**: ✅ Connected

### **Data Sample:**
- **👥 Users**: 5 (admin, supervisor, 2 teknisi, manager)
- **👤 Customers**: 9 (dengan alamat Sukabumi)
- **🔧 Installations**: 4 (dengan GPS Sukabumi)
- **📝 Activity Logs**: 17 (tracking sistem)

---

## 🔐 **Login dengan Email Fake**

### **Admin (Full Access)**
- **Email**: `admin@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Data Pelanggan, Laporan, Export

### **Supervisor (Approval Access)**
- **Email**: `supervisor@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Persetujuan Pelanggan

### **Teknisi (Installation Access)**
- **Email**: `teknisi1@ensia.com` / `teknisi2@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Instalasi, GPS Tracking

---

## 📊 **Data Sample Sukabumi**

### **Pelanggan (9 records)**
1. **Ahmad Wijaya** - Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
2. **Siti Nurhaliza** - Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
3. **Budi Santoso** - Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
4. **Dewi Sartika** - Jl. Gatot Subroto No. 321, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
5. **Rudi Hartono** - Jl. HR Rasuna Said No. 654, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
6. **Eko Prasetyo** - Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
7. **Maya Sari** - Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
8. **Agus Supriyadi** - Jl. Ahmad Yani No. 78, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
9. **Rina Wulandari** - Jl. Pahlawan No. 90, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi

### **Instalasi (4 records)**
1. **Budi Santoso** - 50 meter kabel, Status: Completed
2. **Siti Nurhaliza** - 75 meter kabel, Status: In Progress
3. **Maya Sari** - 60 meter kabel, Status: Completed
4. **Eko Prasetyo** - 40 meter kabel, Status: Assigned

---

## ✨ **Fitur Aplikasi Lengkap**

### **Dashboard Admin**
- ✅ Statistik pelanggan real-time
- ✅ Grafik pemasangan per bulan
- ✅ Overview sistem lengkap

### **Manajemen Pelanggan**
- ✅ Input data pelanggan lengkap
- ✅ Edit dan hapus data pelanggan
- ✅ Pencarian dan filter data
- ✅ Detail pelanggan dengan log aktivitas

### **Persetujuan Supervisor**
- ✅ Review data pelanggan pending
- ✅ Approve atau reject data pelanggan
- ✅ Tracking status persetujuan

### **Instalasi Teknisi**
- ✅ Daftar pelanggan siap diinstalasi
- ✅ Input data instalasi (kabel, GPS)
- ✅ Update status instalasi
- ✅ Tracking lokasi dengan GPS

### **Laporan & Export**
- ✅ Export data ke Excel dan PDF
- ✅ Filter data berdasarkan status dan tanggal
- ✅ Print data pelanggan dalam format PDF
- ✅ Laporan statistik lengkap

---

## 🗄️ **Database MySQL**

### **Tabel:**
- **users** (5 records) - Admin, supervisor, teknisi
- **customers** (9 records) - Data pelanggan Sukabumi
- **installations** (4 records) - Data instalasi dengan GPS
- **activity_logs** (17 records) - Log aktivitas sistem

### **Status:**
- ✅ Database created
- ✅ Tables created
- ✅ Data imported
- ✅ Connection working

---

## 🚀 **Cara Menggunakan**

### **1. Akses Aplikasi**
1. Buka browser ke `http://localhost:8080`
2. Login dengan email dan password yang tersedia
3. Mulai menggunakan fitur-fitur aplikasi

### **2. Test Database**
1. Buka `http://localhost:8080/test_db.php`
2. Pastikan koneksi database berhasil
3. Lihat data sample yang sudah terimport

### **3. Lihat Status**
1. Buka `http://localhost:8080/status.php`
2. Lihat status lengkap aplikasi
3. Akses fitur-fitur yang tersedia

---

## 📱 **Screenshots Fitur**

### **Login Page**
- Form login dengan email fake
- UI modern dengan logo Majuin
- Branding ENSIA lengkap

### **Dashboard**
- Statistik cards dengan data real-time
- Grafik pemasangan per bulan
- Overview sistem lengkap

### **Data Pelanggan**
- Tabel data dengan pagination
- Filter dan pencarian
- CRUD operations lengkap

### **Persetujuan Supervisor**
- Daftar pelanggan pending
- Modal approve/reject
- Tracking status

### **Instalasi Teknisi**
- Daftar tugas instalasi
- Input data GPS dan kabel
- Update status real-time

### **Laporan & Export**
- Export Excel dan PDF
- Filter data lengkap
- Print data pelanggan

---

## 🔧 **Troubleshooting**

### **Jika Error Database**
- Pastikan MySQL service berjalan: `sudo systemctl status mysql`
- Cek konfigurasi di `config/database.php`
- Test koneksi di `http://localhost:8080/test_db.php`

### **Jika Error Login**
- Pastikan menggunakan email yang benar
- Password default: `password`
- Cek data di database

### **Jika Error Export**
- Pastikan mPDF sudah terinstall
- Cek permission folder
- Jalankan `composer install`

---

## 📞 **Support**

**Developer**: Amiruloh  
**Institution**: AMIK CBI Sukabumi  
**Purpose**: Tugas Akhir D3 Manajemen Informatika  

---

## 🎯 **Status: SIAP DIGUNAKAN!**

**Aplikasi ENSIA telah selesai dibuat, database terhubung, dan siap digunakan untuk keperluan Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi!**

**Selamat menggunakan aplikasi ENSIA!** 🎉

---

## 📋 **Quick Access Links**

- **Main App**: http://localhost:8080
- **Status**: http://localhost:8080/status.php
- **Test DB**: http://localhost:8080/test_db.php
- **Info Login**: http://localhost:8080/login_info.html

**Aplikasi berjalan di port 8080 dengan database MySQL yang terhubung dengan baik!**
