<?php
// Demo halaman instalasi teknisi tanpa login
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Data sample untuk demo
$demo_installations = [
    [
        'id' => 1,
        'customer_name' => 'Ahmad Wijaya',
        'customer_phone' => '081234567890',
        'customer_address' => 'Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'status' => 'assigned',
        'kabel_meter' => null,
        'latitude' => null,
        'longitude' => null,
        'alamat_instalasi' => null,
        'catatan' => null,
        'tanggal_instalasi' => null
    ],
    [
        'id' => 2,
        'customer_name' => 'Siti Nurhaliza',
        'customer_phone' => '081234567891',
        'customer_address' => 'Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'status' => 'in_progress',
        'kabel_meter' => 75,
        'latitude' => '-6.9194',
        'longitude' => '106.9270',
        'alamat_instalasi' => 'Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'catatan' => 'Instalasi pending, menunggu konfirmasi pelanggan',
        'tanggal_instalasi' => '2024-01-15 10:30:00'
    ],
    [
        'id' => 3,
        'customer_name' => 'Eko Prasetyo',
        'customer_phone' => '081234567895',
        'customer_address' => 'Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'status' => 'completed',
        'kabel_meter' => 40,
        'latitude' => '-6.9194',
        'longitude' => '106.9270',
        'alamat_instalasi' => 'Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'catatan' => 'Instalasi baru dimulai',
        'tanggal_instalasi' => '2024-01-20 14:15:00'
    ]
];

$approved_customers = [
    [
        'id' => 4,
        'nama_lengkap' => 'Rudi Hartono',
        'nomor_hp' => '081234567894',
        'alamat_lengkap' => 'Jl. HR Rasuna Said No. 654, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'email' => 'rudi.hartono@email.com'
    ],
    [
        'id' => 5,
        'nama_lengkap' => 'Maya Sari',
        'nomor_hp' => '081234567896',
        'alamat_lengkap' => 'Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'email' => 'maya.sari@email.com'
    ]
];

$stats = [
    'total' => 3,
    'assigned' => 1,
    'in_progress' => 1,
    'completed' => 1,
    'failed' => 0
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Halaman Instalasi Teknisi - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .demo-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .installation-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
        }
        .installation-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .status-badge {
            font-size: 0.75rem;
        }
        .customer-card {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 0.75rem;
            border-left: 4px solid #2196f3;
        }
        .btn-start {
            background: #28a745;
            border-color: #28a745;
            color: white;
        }
        .btn-start:hover {
            background: #218838;
            border-color: #1e7e34;
            color: white;
        }
        .btn-update {
            background: #ffc107;
            border-color: #ffc107;
            color: #212529;
        }
        .btn-update:hover {
            background: #e0a800;
            border-color: #d39e00;
            color: #212529;
        }
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 1rem;
        }
        .stats-card h3 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>🔧 Demo - Halaman Instalasi Teknisi</h3>
            <p class="lead">Teknisi dapat memulai dan mengelola instalasi pelanggan</p>
        </div>
        
        <!-- Features Info -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-play me-2"></i>Mulai Instalasi</h6>
                    <p class="text-muted small mb-0">Teknisi dapat memulai instalasi untuk pelanggan yang sudah approved</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-map-marker-alt me-2"></i>GPS Tracking</h6>
                    <p class="text-muted small mb-0">Input koordinat GPS dan data instalasi lengkap</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-tasks me-2"></i>Kelola Status</h6>
                    <p class="text-muted small mb-0">Update status instalasi dari assigned hingga completed</p>
                </div>
            </div>
        </div>
        
        <!-- Statistik -->
        <div class="row mb-4">
            <div class="col-md-2">
                <div class="stats-card">
                    <h3><?php echo $stats['total']; ?></h3>
                    <p class="text-muted mb-0">Total</p>
                </div>
            </div>
            <div class="col-md-2">
                <div class="stats-card">
                    <h3 class="text-warning"><?php echo $stats['assigned']; ?></h3>
                    <p class="text-muted mb-0">Assigned</p>
                </div>
            </div>
            <div class="col-md-2">
                <div class="stats-card">
                    <h3 class="text-info"><?php echo $stats['in_progress']; ?></h3>
                    <p class="text-muted mb-0">In Progress</p>
                </div>
            </div>
            <div class="col-md-2">
                <div class="stats-card">
                    <h3 class="text-success"><?php echo $stats['completed']; ?></h3>
                    <p class="text-muted mb-0">Completed</p>
                </div>
            </div>
            <div class="col-md-2">
                <div class="stats-card">
                    <h3 class="text-danger"><?php echo $stats['failed']; ?></h3>
                    <p class="text-muted mb-0">Failed</p>
                </div>
            </div>
            <div class="col-md-2">
                <div class="stats-card">
                    <h3 class="text-primary"><?php echo count($approved_customers); ?></h3>
                    <p class="text-muted mb-0">Siap Instalasi</p>
                </div>
            </div>
        </div>
        
        <!-- Pelanggan Siap Diinstalasi -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-user-check me-2"></i>Pelanggan Siap Diinstalasi
                <span class="badge bg-primary ms-2"><?php echo count($approved_customers); ?></span>
            </h4>
            
            <div class="row">
                <?php foreach ($approved_customers as $customer): ?>
                <div class="col-md-6 mb-3">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                            <span class="badge bg-success status-badge">Approved</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-2">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo substr(htmlspecialchars($customer['alamat_lengkap']), 0, 50) . '...'; ?>
                        </p>
                        <button class="btn btn-start btn-sm" onclick="startInstallation(<?php echo $customer['id']; ?>, '<?php echo htmlspecialchars($customer['nama_lengkap']); ?>')">
                            <i class="fas fa-play me-1"></i>Mulai Instalasi
                        </button>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Instalasi Aktif -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-tools me-2"></i>Instalasi Aktif
                <span class="badge bg-info ms-2"><?php echo count($demo_installations); ?></span>
            </h4>
            
            <div class="row">
                <?php foreach ($demo_installations as $installation): ?>
                <div class="col-md-6 mb-3">
                    <div class="installation-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($installation['customer_name']); ?></h6>
                            <span class="badge bg-<?php 
                                echo $installation['status'] == 'assigned' ? 'warning' : 
                                    ($installation['status'] == 'in_progress' ? 'info' : 'success'); 
                            ?> status-badge">
                                <?php echo ucfirst(str_replace('_', ' ', $installation['status'])); ?>
                            </span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($installation['customer_phone']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo substr(htmlspecialchars($installation['customer_address']), 0, 50) . '...'; ?>
                        </p>
                        
                        <?php if ($installation['status'] == 'assigned'): ?>
                            <p class="text-muted small mb-2">
                                <i class="fas fa-info-circle me-1"></i>Belum ada data instalasi
                            </p>
                            <button class="btn btn-update btn-sm" onclick="updateInstallation(<?php echo $installation['id']; ?>, '<?php echo htmlspecialchars($installation['customer_name']); ?>')">
                                <i class="fas fa-edit me-1"></i>Input Data Instalasi
                            </button>
                        <?php else: ?>
                            <p class="text-muted small mb-1">
                                <i class="fas fa-ruler me-1"></i>Kabel: <?php echo $installation['kabel_meter']; ?> meter
                            </p>
                            <p class="text-muted small mb-1">
                                <i class="fas fa-map-pin me-1"></i>GPS: <?php echo $installation['latitude']; ?>, <?php echo $installation['longitude']; ?>
                            </p>
                            <p class="text-muted small mb-1">
                                <i class="fas fa-calendar me-1"></i>Tanggal: <?php echo date('d M Y H:i', strtotime($installation['tanggal_instalasi'])); ?>
                            </p>
                            <p class="text-muted small mb-2">
                                <i class="fas fa-sticky-note me-1"></i>Catatan: <?php echo htmlspecialchars($installation['catatan']); ?>
                            </p>
                            <button class="btn btn-update btn-sm" onclick="updateInstallation(<?php echo $installation['id']; ?>, '<?php echo htmlspecialchars($installation['customer_name']); ?>')">
                                <i class="fas fa-edit me-1"></i>Update Instalasi
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Features Detail -->
        <div class="row">
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-play-circle me-2 text-success"></i>Mulai Instalasi</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Pilih pelanggan yang sudah approved</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Klik "Mulai Instalasi"</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Status berubah menjadi "Assigned"</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Siap untuk input data instalasi</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-edit me-2 text-warning"></i>Input Data Instalasi</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Panjang kabel (meter)</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Koordinat GPS (lat, lng)</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Alamat instalasi</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Catatan instalasi</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Update status</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_add_customer.php" class="btn btn-outline-light">
                <i class="fas fa-user-plus me-2"></i>Demo Tambah Pelanggan
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function startInstallation(customerId, customerName) {
            if (confirm('Mulai instalasi untuk ' + customerName + '?')) {
                alert('Instalasi berhasil dimulai!\n\nStatus: Assigned\nTeknisi dapat mulai input data instalasi.');
                // Simulate page refresh
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        }
        
        function updateInstallation(installationId, customerName) {
            alert('Membuka form update instalasi untuk ' + customerName + '\n\nForm akan menampilkan:\n- Input panjang kabel\n- Input koordinat GPS\n- Input alamat instalasi\n- Input catatan\n- Update status');
        }
    </script>
</body>
</html>
