# 🔧 Fitur Input Data Pelanggan oleh Teknisi - ENSIA

## ✅ **Fitur Lengkap: Teknisi Input Data Pelanggan yang Daftar Internet**

Teknisi sekarang dapat input data pelanggan yang daftar internet langsung di lapangan dengan fitur yang lengkap dan user-friendly.

---

## 🎯 **Fitur Utama**

### **📋 Form Input Data Lengkap:**
- **Data Pribadi**: Nama lengkap, pekerjaan, HP, email, NIK KTP
- **Upload KTP**: Upload foto KTP dengan preview dan validasi
- **Alamat Lengkap**: Alamat tempat tinggal pelanggan
- **Paket Internet**: 4 pilihan paket dengan harga berbeda
- **Catatan Instalasi**: Catatan khusus untuk instalasi

### **🌐 Pilihan Paket Internet:**
- **Paket Basic**: 10 Mbps - Rp 150.000/bulan
- **Paket Standard**: 25 Mbps - Rp 250.000/bulan
- **Paket Premium**: 50 Mbps - Rp 400.000/bulan
- **Paket Business**: 100 Mbps - Rp 600.000/bulan

### **📱 Upload Foto KTP:**
- **Format**: JPG/PNG maksimal 5MB
- **Preview**: Tampilan preview sebelum upload
- **Validasi**: Client-side dan server-side validation
- **Storage**: File disimpan di `uploads/ktp/`

---

## 🎨 **Tampilan Visual**

### **Form Sections:**
- **👤 Data Pribadi**: Input data personal pelanggan
- **📍 Alamat**: Input alamat lengkap
- **🌐 Paket Internet**: Pilihan paket dengan visual menarik
- **📝 Catatan Instalasi**: Catatan khusus untuk instalasi

### **Paket Selection:**
- **Visual Cards**: Setiap paket dalam card terpisah
- **Hover Effects**: Efek hover saat memilih paket
- **Selected State**: Visual feedback saat paket dipilih
- **Price Display**: Harga ditampilkan dengan jelas

### **Upload KTP:**
- **Drag & Drop**: Interface yang user-friendly
- **Preview**: Tampilan preview foto sebelum upload
- **Remove Button**: Tombol hapus foto
- **Validation**: Pesan error yang jelas

---

## 🛠️ **Implementasi Teknis**

### **1. Database Schema:**
```sql
-- Kolom baru di tabel customers
ALTER TABLE customers 
ADD COLUMN paket_internet VARCHAR(50) NULL AFTER foto_ktp,
ADD COLUMN harga_paket INT NULL AFTER paket_internet,
ADD COLUMN catatan_instalasi TEXT NULL AFTER harga_paket;
```

### **2. PHP Form Handling:**
```php
// Handle form submission
if ($_POST) {
    $nama_lengkap = sanitizeInput($_POST['nama_lengkap']);
    $pekerjaan = sanitizeInput($_POST['pekerjaan']);
    $alamat_lengkap = sanitizeInput($_POST['alamat_lengkap']);
    $nomor_hp = sanitizeInput($_POST['nomor_hp']);
    $email = sanitizeInput($_POST['email']);
    $nik_ktp = sanitizeInput($_POST['nik_ktp']);
    $paket_internet = sanitizeInput($_POST['paket_internet']);
    $harga_paket = (int)$_POST['harga_paket'];
    $catatan_instalasi = sanitizeInput($_POST['catatan_instalasi']);
    
    // Handle upload foto KTP
    $foto_ktp = '';
    if (isset($_FILES['foto_ktp']) && $_FILES['foto_ktp']['error'] == 0) {
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png'];
        $max_size = 5 * 1024 * 1024; // 5MB
        
        if (in_array($_FILES['foto_ktp']['type'], $allowed_types) && 
            $_FILES['foto_ktp']['size'] <= $max_size) {
            $file_extension = pathinfo($_FILES['foto_ktp']['name'], PATHINFO_EXTENSION);
            $foto_ktp = 'ktp_' . time() . '_' . $nik_ktp . '.' . $file_extension;
            $upload_path = 'uploads/ktp/' . $foto_ktp;
            
            if (!move_uploaded_file($_FILES['foto_ktp']['tmp_name'], $upload_path)) {
                $error = 'Gagal mengupload foto KTP!';
            }
        } else {
            $error = 'Format foto KTP tidak valid! Gunakan JPG/PNG maksimal 5MB.';
        }
    }
    
    // Insert customer data
    $query = "INSERT INTO customers (nama_lengkap, pekerjaan, alamat_lengkap, nomor_hp, email, nik_ktp, foto_ktp, paket_internet, harga_paket, catatan_instalasi, created_by, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')";
    $stmt = $db->prepare($query);
    $stmt->execute([$nama_lengkap, $pekerjaan, $alamat_lengkap, $nomor_hp, $email, $nik_ktp, $foto_ktp, $paket_internet, $harga_paket, $catatan_instalasi, $_SESSION['user_id']]);
}
```

### **3. HTML Form Interface:**
```html
<!-- Data Pribadi -->
<div class="form-section">
    <h5><i class="fas fa-user me-2"></i>Data Pribadi</h5>
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="nama_lengkap" class="form-label">Nama Lengkap <span class="required">*</span></label>
            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="pekerjaan" class="form-label">Pekerjaan <span class="required">*</span></label>
            <input type="text" class="form-control" id="pekerjaan" name="pekerjaan" required>
        </div>
    </div>
    <!-- ... more fields ... -->
</div>

<!-- Paket Internet -->
<div class="form-section">
    <h5><i class="fas fa-wifi me-2"></i>Paket Internet</h5>
    <div class="row">
        <div class="col-md-6">
            <div class="paket-option" onclick="selectPaket('Basic', 150000)">
                <input type="radio" name="paket_internet" value="Basic" id="paket_basic">
                <h6>Paket Basic</h6>
                <p class="mb-1">Kecepatan: 10 Mbps</p>
                <p class="mb-1">Kuota: Unlimited</p>
                <p class="price">Rp 150.000/bulan</p>
            </div>
        </div>
        <!-- ... more packages ... -->
    </div>
</div>
```

### **4. JavaScript Functionality:**
```javascript
// Foto KTP preview
document.getElementById('foto_ktp').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('preview-img').src = e.target.result;
            document.getElementById('foto-preview').style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
});

// Paket selection
function selectPaket(paket, harga) {
    // Remove selected class from all options
    document.querySelectorAll('.paket-option').forEach(option => {
        option.classList.remove('selected');
    });
    
    // Add selected class to clicked option
    event.currentTarget.classList.add('selected');
    
    // Set hidden input value
    document.getElementById('harga_paket').value = harga;
}
```

---

## 📊 **Data Flow**

### **1. Teknisi Input Data:**
- Teknisi input data pelanggan lengkap
- Pilih paket internet yang sesuai
- Upload foto KTP
- Input catatan instalasi
- Submit form

### **2. Data Validation:**
- Client-side validation (JavaScript)
- Server-side validation (PHP)
- File upload validation
- Database validation

### **3. Data Storage:**
- Data disimpan di database
- Foto KTP disimpan di folder uploads
- Status: `pending` (menunggu approval)
- Log activity tersimpan

### **4. Supervisor Approval:**
- Data muncul di halaman supervisor
- Supervisor review data
- Approve atau reject
- Status berubah sesuai keputusan

---

## 🧪 **Test & Demo**

### **URL Demo:**
- **Demo Input**: `http://localhost:8080/demo_teknisi_add_customer.php`
- **Main Input**: `http://localhost:8080/teknisi_add_customer.php` (login required)

### **Data Sample:**
- **Nama**: Budi Santoso
- **Pekerjaan**: Wiraswasta
- **HP**: 081234567897
- **Email**: budi.santoso@email.com
- **NIK**: 3201234567890123
- **Alamat**: Jl. Pahlawan No. 789, Sukabumi
- **Paket**: Standard (25 Mbps - Rp 250.000)

---

## 🎯 **User Experience**

### **Teknisi Workflow:**
1. **Login** sebagai teknisi
2. **Akses Menu** "Tambah Pelanggan"
3. **Input Data** pelanggan lengkap
4. **Pilih Paket** internet yang sesuai
5. **Upload KTP** dengan preview
6. **Input Catatan** instalasi
7. **Submit** data pelanggan
8. **Status Pending** menunggu approval

### **Visual Feedback:**
- **Real-time Validation**: Validasi saat input
- **Preview KTP**: Tampilan preview foto
- **Paket Selection**: Visual feedback saat pilih paket
- **Success Message**: Konfirmasi berhasil simpan

---

## 🔒 **Keamanan & Validasi**

### **Role-based Access:**
- Hanya teknisi yang bisa akses
- Validasi session dan role
- Teknisi hanya bisa input data sendiri

### **Data Validation:**
- Validasi format email
- Validasi format NIK KTP
- Validasi file upload (type, size)
- Sanitasi input data

### **File Upload Security:**
- Validasi file type (JPG/PNG only)
- Validasi file size (max 5MB)
- Unique filename generation
- Secure file storage

---

## 📱 **Responsive Design**

### **Mobile First:**
- Layout responsive di semua device
- Touch-friendly form elements
- Optimized untuk mobile
- Sidebar collapsible

### **Form Layout:**
- **Mobile**: Single column layout
- **Tablet**: Two column layout
- **Desktop**: Multi column layout

---

## ✅ **Status: SELESAI**

**Fitur Input Data Pelanggan oleh Teknisi telah berhasil diimplementasikan!**

**Fitur yang tersedia:**
- ✅ Form input data pelanggan lengkap
- ✅ Upload foto KTP dengan preview
- ✅ Pilihan paket internet (4 pilihan)
- ✅ Input catatan instalasi
- ✅ Validasi data lengkap
- ✅ Responsive design
- ✅ User-friendly interface

---

## 🔗 **Akses Demo**

- **Demo Input**: http://localhost:8080/demo_teknisi_add_customer.php
- **Main Input**: http://localhost:8080/teknisi_add_customer.php (login required)

**Teknisi sekarang dapat input data pelanggan yang daftar internet langsung di lapangan!** 🎉

**Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi**
