# 🎉 Aplikasi ENSIA (Engineer On Site App) - LENGKAP
## PT Maintek Juara Intisolusi

### 📍 **Lokasi: Kota Sukabumi**
Semua data sample menggunakan alamat di **Kota Sukabumi** dengan format lengkap:
- Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Koordinat GPS: -6.9194, 106.9270

---

## 🔐 **Login dengan Email Fake**

### **Admin**
- `admin@ensia.com` / `password`
- `manager@ensia.com` / `password`

### **Supervisor**
- `supervisor@ensia.com` / `password`

### **Teknisi**
- `teknisi1@ensia.com` / `password`
- `teknisi2@ensia.com` / `password`

---

## 📊 **Data Sample Pelanggan Sukabumi**

### **Status Pending (2 pelanggan)**
1. **Ahmad Wijaya** - Karyawan Swasta
   - Alamat: Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567890

2. **Agus Supriyadi** - Sopir
   - Alamat: Jl. Ahmad Yani No. 78, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567897

### **Status Approved (2 pelanggan)**
1. **Siti Nurhaliza** - Guru
   - Alamat: Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567891

2. **Eko Prasetyo** - Pedagang
   - Alamat: Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567895

### **Status Installed (2 pelanggan)**
1. **Budi Santoso** - Wiraswasta
   - Alamat: Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567892

2. **Maya Sari** - Perawat
   - Alamat: Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567896

### **Status Cancelled (2 pelanggan)**
1. **Dewi Sartika** - PNS
   - Alamat: Jl. Gatot Subroto No. 321, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567893

2. **Rina Wulandari** - Ibu Rumah Tangga
   - Alamat: Jl. Pahlawan No. 90, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
   - HP: 081234567898

---

## 🔧 **Data Instalasi Sample**

### **Instalasi Selesai (2)**
1. **Budi Santoso** - 50 meter kabel
   - Teknisi: Teknisi 1
   - Tanggal: 15 Januari 2024
   - Status: Completed

2. **Maya Sari** - 60 meter kabel
   - Teknisi: Teknisi 2
   - Tanggal: 20 Januari 2024
   - Status: Completed

### **Instalasi Berlangsung (2)**
1. **Siti Nurhaliza** - 75 meter kabel
   - Teknisi: Teknisi 1
   - Status: In Progress

2. **Eko Prasetyo** - 40 meter kabel
   - Teknisi: Teknisi 2
   - Status: Assigned

---

## 🚀 **Cara Menjalankan Aplikasi**

### **1. Setup Database**
```bash
# Buat database
mysql -u root -p
CREATE DATABASE ensia_db;

# Import schema
mysql -u root -p ensia_db < database/schema.sql
```

### **2. Install Dependencies**
```bash
cd /home/lab-mji/ensia1
composer install
```

### **3. Konfigurasi Database**
Edit `config/database.php` sesuai setting MySQL Anda.

### **4. Akses Aplikasi**
- **URL**: `http://localhost/ensia1`
- **Instalasi Otomatis**: `http://localhost/ensia1/install.php`
- **Info Login**: `http://localhost/ensia1/login_info.html`

---

## 📱 **Fitur Aplikasi**

### **Dashboard Admin**
- ✅ Statistik pelanggan (9 total: 2 pending, 2 approved, 2 installed, 2 cancelled)
- ✅ Grafik pemasangan per bulan
- ✅ Overview lengkap sistem

### **Manajemen Pelanggan**
- ✅ Input data pelanggan lengkap
- ✅ Edit dan hapus data pelanggan
- ✅ Pencarian dan filter data
- ✅ Detail pelanggan dengan log aktivitas

### **Persetujuan Supervisor**
- ✅ Review data pelanggan pending
- ✅ Approve atau reject data pelanggan
- ✅ Tracking status persetujuan

### **Instalasi Teknisi**
- ✅ Daftar pelanggan siap diinstalasi
- ✅ Input data instalasi (kabel, GPS)
- ✅ Update status instalasi
- ✅ Tracking lokasi dengan GPS

### **Laporan & Export**
- ✅ Export data ke Excel dan PDF
- ✅ Filter data berdasarkan status dan tanggal
- ✅ Print data pelanggan dalam format PDF
- ✅ Laporan statistik lengkap

---

## 🎨 **UI/UX Features**

- ✅ Logo Majuin di sidebar dan header
- ✅ Branding "Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi"
- ✅ Footer dengan credit developer
- ✅ Responsive design dengan Bootstrap 5
- ✅ Modern gradient design
- ✅ Chart.js untuk grafik interaktif

---

## 🔒 **Keamanan**

- ✅ Role-based access control
- ✅ Session management
- ✅ Input validation dan sanitization
- ✅ SQL injection protection
- ✅ XSS protection
- ✅ Activity logging

---

## 📁 **Struktur File**

```
ensia1/
├── 📁 config/           # Konfigurasi aplikasi
├── 📁 database/         # Schema database
├── 📁 vendor/           # Dependencies
├── 🔐 login.php         # Halaman login
├── 📊 dashboard.php     # Dashboard
├── 👥 customers.php     # Data pelanggan
├── ➕ add_customer.php  # Tambah pelanggan
├── ✏️ customer_edit.php # Edit pelanggan
├── 👁️ customer_detail.php # Detail pelanggan
├── 🖨️ customer_print.php # Print PDF
├── ✅ approvals.php     # Persetujuan supervisor
├── 🔧 installations.php # Instalasi teknisi
├── 📈 reports.php       # Laporan & export
├── 🛠️ install.php       # Script instalasi
├── 📖 README.md         # Dokumentasi
└── 📋 SUMMARY.md        # Ringkasan ini
```

---

## 🎯 **Status Aplikasi: LENGKAP & SIAP DIGUNAKAN!**

Aplikasi ENSIA telah selesai dibuat dengan:
- ✅ Semua fitur yang diminta
- ✅ Data sample lengkap dengan alamat Sukabumi
- ✅ Login menggunakan email fake
- ✅ UI/UX modern dan responsive
- ✅ Sistem keamanan lengkap
- ✅ Dokumentasi lengkap

**Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi**
